/*
JavaScript-specific functions for Mathomatic
Part of the JavaScript port of Mathomatic by Blenheimears.com
*/

/*
Changelog:
July 6, 2014:
Search for bad characters before printing. Fixes problem where equations didn't show up after typing commands like "help"
*/

#include <stdio.h>
#include <stdlib.h>
#include "mathomatic.h"

inline int bad_character(char x){
/* This is necessary because calling matho_process() with certain commands will fill "output" with garbage that we don't want to print. */
int i;
char *valid_characters="\n qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890!@#$%^&*()-=_+[]{}|\\;:'\",./<>?`~\0";
for(i=0; valid_characters[i]!='\0'; i++){
if(x == valid_characters[i])
return 0;
}
return 1;
}

/* we assume that matho_init has already been called by the HTML page */

int js_solve(char *eq){
char *output;
int i;
int rv;
rv=matho_process(eq, &output);

for(i=0;output[i]!='\0';i++){
if(bad_character(output[i])){
if(rv)
free(output);
return 0;
}
}

puts(output);

if(rv)
free(output);

return 0;
}
